/*******************************************************
Filename		:  	DW_DISPLAY_CALENDAR.sql
Release 		:  	STORET c2.0
SIR			:  	1435
Description		:  	Dynamically builds a date (Month, Day, Year) selection list.  Year spans
				from 1900 to 2050.
Author			:  	Christine Tsang (based on Display_calendar.sql)
Date			: 	March 17, 2003
				April 8, 2003 -- added JS calls to smart date script
				4/9/2003 -- added START_TAB parm to indicate the first tabindex of the
					date selection group.
Comments		:  	
**********************************************************/
CREATE OR REPLACE PROCEDURE DW_DISPLAY_CALENDAR
(
DATE_NAME  	IN VARCHAR2,
RANGE_NUM   IN NUMBER DEFAULT 1,
START_TAB	IN NUMBER DEFAULT 10,
FROM_YEAR 	IN NUMBER DEFAULT 1900,
TO_YEAR 	IN NUMBER DEFAULT 2050
)
AS
is_current_month  varchar2(4) := null;
current_month 	varchar2(3);
select_day 		number default 0;
select_year		number default TO_NUMBER( TO_CHAR(SYSDATE,'YYYY'));
date_range        varchar2(1);
tabi			varchar2(3);
--
BEGIN
date_range := to_char(range_num);
--
--MONTH
--
Select to_char(SYSDATE,'MON') into current_month from dual;
--
--If populating the date from, then default start to Jan 1, 1900
--
IF DATE_NAME = 'FROM' then
  tabi := to_char(START_TAB + ((range_num-1)*6));
  IF DATE_RANGE = '1' THEN
	current_month := 'JAN';
  ELSE
      current_month := '---';
  END IF;
ELSIF DATE_NAME = 'END' then
  tabi := to_char(START_TAB + 3 + ((range_num-1)*6));
  IF DATE_RANGE <> '1' THEN
      current_month := '---';
  END IF;
END IF;

htp.print('<font face="Courier">');

--htp.formSelectOpen(DATE_NAME||'_MON'||DATE_RANGE, NSIZE => 1, cattributes => 'style="font: 10pt/12pt COURIER" onChange="ChangeOptionDays('''||DATE_NAME||''','||DATE_RANGE||')"');
htp.print('<SELECT NAME="' ||DATE_NAME||'_MON'||DATE_RANGE||'" SIZE="1" style="font: 10pt/12pt COURIER" tabindex='||tabi||' onChange="ChangeOptionDays('''||DATE_NAME||''','||DATE_RANGE||')">');
IF current_month = '---' THEN
	htp.formSelectOption('---', cattributes => 'VALUE= DUMMY', cselected => 'TRUE');
END IF;
			is_current_month := null;
			if current_month = 'JAN' then is_current_month := 'TRUE'; end if;
		htp.formSelectOption('JAN',cattributes => 'VALUE= JAN',CSELECTED => is_current_month);
			is_current_month := null;
			if current_month = 'FEB' then is_current_month := 'TRUE'; end if;
		htp.formSelectOption('FEB',cattributes => 'VALUE= FEB',CSELECTED => is_current_month);
			is_current_month := null;
			if current_month = 'MAR' then is_current_month := 'TRUE'; end if;
		htp.formSelectOption('MAR',cattributes => 'VALUE= MAR',CSELECTED => is_current_month);
			is_current_month := null;
			if current_month = 'APR' then is_current_month := 'TRUE'; end if;
		htp.formSelectOption('APR',cattributes => 'VALUE= APR',CSELECTED => is_current_month);
			is_current_month := null;
			if current_month = 'MAY' then is_current_month := 'TRUE'; end if;
		htp.formSelectOption('MAY',cattributes => 'VALUE= MAY',CSELECTED => is_current_month);
			is_current_month := null;
			if current_month = 'JUN' then is_current_month := 'TRUE'; end if;
		htp.formSelectOption('JUN',cattributes => 'VALUE= JUN',CSELECTED => is_current_month);
			is_current_month := null;
			if current_month = 'JUL' then is_current_month := 'TRUE'; end if;
		htp.formSelectOption('JUL',cattributes => 'VALUE= JUL',CSELECTED => is_current_month);
			is_current_month := null;
			if current_month = 'AUG' then is_current_month := 'TRUE'; end if;
		htp.formSelectOption('AUG',cattributes => 'VALUE= AUG',CSELECTED => is_current_month);
			is_current_month := null;
			if current_month = 'SEP' then is_current_month := 'TRUE'; end if;
		htp.formSelectOption('SEP',cattributes => 'VALUE= SEP',CSELECTED => is_current_month);
			is_current_month := null;
			if current_month = 'OCT' then is_current_month := 'TRUE'; end if;
		htp.formSelectOption('OCT',cattributes => 'VALUE= OCT',CSELECTED => is_current_month);
			is_current_month := null;
			if current_month = 'NOV' then is_current_month := 'TRUE'; end if;
		htp.formSelectOption('NOV',cattributes => 'VALUE= NOV',CSELECTED => is_current_month);
			is_current_month := null;
			if current_month = 'DEC' then is_current_month := 'TRUE'; end if;
		htp.formSelectOption('DEC',cattributes => 'VALUE= DEC',CSELECTED => is_current_month);
htp.formSelectClose;
htp.print('</font>');

--
--DAY
--
--
--If populating the date from, then default start to Jan 1, 1900
--
IF DATE_NAME = 'FROM' THEN
  tabi := to_char(START_TAB + 1 + ((range_num-1)*6));
  IF DATE_RANGE = '1' THEN
	select_day := 1;
  ELSE
      select_day := 0;
  END IF;
ELSIF DATE_NAME = 'END' THEN
  tabi := to_char(START_TAB + 4 + ((range_num-1)*6));
  IF DATE_RANGE = '1' THEN
	select_day := TO_CHAR(SYSDATE,'DD');
  ELSE
      select_day := 0;
  END IF;      
END IF;

htp.print('<font face="Courier">');

--htp.formSelectOpen(DATE_NAME||'_DD'||DATE_RANGE, NSIZE => 1, cattributes => 'style="font: 10pt/12pt COURIER"');
htp.print('<SELECT NAME="' ||DATE_NAME||'_DD'||DATE_RANGE||'" SIZE="1" style="font: 10pt/12pt COURIER" tabindex='||tabi||'>');
IF select_day = 0 THEN
	htp.formSelectOption('--', cattributes => 'VALUE= 0', cselected => 'TRUE');
END IF;
FOR i IN 1..31 LOOP
	IF i = select_day THEN
		htp.formSelectOption(i, cattributes => 'VALUE='|| i, cselected => 'TRUE');
	ELSE
		htp.formSelectOption(i, cattributes => 'VALUE='|| i);
	END IF;
END LOOP;
htp.formSelectClose;
htp.print('</font>');

--
--YEAR
--
IF DATE_NAME = 'FROM' THEN
  tabi := to_char(START_TAB + 2 + ((range_num-1)*6));
  IF DATE_RANGE = '1' THEN
	select_year:=1900;
  ELSE
      select_year:= 0;
  END IF;
ELSIF DATE_NAME='END' THEN
  tabi := to_char(START_TAB + 5 + ((range_num-1)*6));
  IF DATE_RANGE = '1' THEN
	select_year:=TO_NUMBER( TO_CHAR(SYSDATE,'YYYY')) ;
  ELSE
      select_year:= 0;
  END IF;
END IF;

htp.print('<font face="Courier">');

--htp.formSelectOpen(DATE_NAME||'_YYYY'||DATE_RANGE, NSIZE => 1, cattributes => 'style="font: 10pt/12pt COURIER" tabindex=12 onChange="ChangeOptionDays('''||DATE_NAME||''','||DATE_RANGE||')"');
htp.print('<SELECT NAME="' ||DATE_NAME||'_YYYY'||DATE_RANGE||'" SIZE="1" style="font: 10pt/12pt COURIER" tabindex='||tabi||' onChange="ChangeOptionDays('''||DATE_NAME||''','||DATE_RANGE||')">');
IF select_year = 0 THEN
	htp.formSelectOption('----', cattributes => 'VALUE= 0', cselected => 'TRUE');
END IF;
FOR i IN FROM_YEAR..TO_YEAR LOOP
	IF i = select_year then
		htp.formSelectOption(i, cattributes => 'VALUE='|| i, cselected => 'TRUE');
	ELSE
		htp.formSelectOption(i, cattributes => 'VALUE='|| i);
	END IF;
--
END LOOP;
htp.formSelectClose;
htp.print('</font>');

END;
/
show errors;
